use "$directory/Gallup World Poll/Gallup_micro", clear
egen t=tag(cty)
egen popav=mean(pop), by(cty)
egen poprank=rank(popav) if t==1, field
tomode poprank, by(cty) replace

* Figure 1: No satiation for the biggest 25 countries
qui foreach c of numlist 1/25 {
	noi di("`c'")
	lowess sat_current_z ln_inc if poprank==`c' , nograph gen(low_`c') 
	summ ln_inc if poprank==`c', det
	replace low_`c'=. if ln_inc<r(p10) | ln_inc>r(p90)
}
egen low=rmin(low_*)
egen min_inc=min(inc) if low~=., by(cty)
egen max_inc=max(inc) if low~=., by(cty)
egen min_low=min(low), by(cty)
gen c=cty if inc==min_inc 
egen points=tag(inc cty)

local sd : char sat_current_z[sd]
local mean : char sat_current_z[mean]
local ylab ""
foreach i of num 4/8 {
	local yl=(`i'-`mean')/`sd'
	local ylab "`ylab' `yl' " `i' ""
}

twoway ///
	(connected low_1 inc , sort /* lcolor(gs1) mlabcolor(gs1) */ lpattern(solid) msym(none) mlab(c) mlabpos(9) yaxis(1 2)) ///
	(connected low_2 inc , sort /* lcolor(gs1) mlabcolor(gs1) */ lpattern(dash) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_3 inc , sort /* lcolor(gs2) mlabcolor(gs2) */ lpattern(dot) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_4 inc , sort /* lcolor(gs2) mlabcolor(gs2) */ lpattern(dot) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_5 inc , sort /* lcolor(gs2) mlabcolor(gs2) */ lpattern(dash_dot) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_6 inc , sort /* lcolor(gs3) mlabcolor(gs3) */ lpattern(shortdash) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_7 inc , sort /* lcolor(gs3) mlabcolor(gs3) */ lpattern(shortdash_dot) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_8 inc , sort /* lcolor(gs4) mlabcolor(gs4) */ lpattern(longdash) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_9 inc , sort /* lcolor(gs4) mlabcolor(gs4) */ lpattern(longdash_dot) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_10 inc , sort /* lcolor(gs5) mlabcolor(gs5) */ lpattern(solid) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_11 inc , sort /* lcolor(gs5) mlabcolor(gs5) */ lpattern(dash) msym(none) mlab(c) mlabpos(9)) ///0
	(connected low_12 inc , sort /* lcolor(gs6) mlabcolor(gs6) */ lpattern(dot) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_13 inc , sort /* lcolor(gs6) mlabcolor(gs6) */ lpattern(dash_dot) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_14 inc , sort /* lcolor(gs7) mlabcolor(gs7) */ lpattern(shortdash) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_15 inc , sort /* lcolor(gs7) mlabcolor(gs7) */ lpattern(shortdash_dot) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_16 inc , sort /* lcolor(gs8) mlabcolor(gs8) */ lpattern(longdash) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_17 inc , sort /* lcolor(gs8) mlabcolor(gs8) */ lpattern(solid) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_18 inc , sort /* lcolor(gs9) mlabcolor(gs9) */ lpattern(dash) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_19 inc , sort /* lcolor(gs9) mlabcolor(gs9) */ lpattern(dot) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_20 inc , sort /* lcolor(gs10) mlabcolor(gs10) */ lpattern(dash_dot) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_21 inc , sort /* lcolor(gs10) mlabcolor(gs10) */ lpattern(shortdash) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_22 inc , sort /* lcolor(gs11) mlabcolor(gs11) */ lpattern(shortdash_dot) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_23 inc , sort /* lcolor(gs11) mlabcolor(gs11) */ lpattern(longdash) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_24 inc , sort /* lcolor(gs12) mlabcolor(gs12) */ lpattern(longdash_dot) msym(none) mlab(c) mlabpos(9)) ///
	(connected low_25 inc , sort /* lcolor(gs12) mlabcolor(gs12) */ lpattern(solid) msym(none) mlab(c) mlabpos(9)) ///
	if inc>.5 & inc<128 & points==1 ///
, ///
	legend(off) ///
	xscale(log) xlabel(0.5 1 2 4 8 16 32 64 128) xtitle("Annual household income (thousands of dollars, log scale)") ///
	ylabel(`ylab', angle(horizontal) format(%9.0f)) ///
	ytitle("Satisfaction Ladder (standardized)") ///
	ylabel(-1(.5)1 , axis(2) angle(horizontal) format(%9.1f)) ///
	ytitle("Satisfaction Ladder (normalized scale)", axis(2)) ///
	xsize(10) ysize(7.5) name(xs25country, replace)
graph export "$directory/Charts/fig2.eps", replace
graph save "$directory/Charts/fig2.gph", replace


* Figure 2: No difference above or below other cutpoints
use "$directory/Gallup World Poll/Gallup_micro", clear
egen t=tag(cty)
for X in any 8 15 25 p25 p50 p75: gen brich_X=. \ gen bpoor_X=. \ gen serich_X=. \ gen sepoor_X=. \ gen diff_X=. \ gen sediff_X=. \ gen nrich_X=. \ gen npoor_X=.
levelsof cty if ln_inc~=. & sat_current_z~=., local(ctys)
qui foreach c of local ctys { 
	noisily di("Country: `c';")
	for ! in numlist 8 15 25: gen rich_!=(inc>=!)*(ln(inc)-ln(!)) if cty=="`c'" \ gen poor_!=(inc<!)*(ln(inc)-ln(!)) if cty=="`c'"
	summ inc if cty=="`c'" & sat_current_z~=. [w=wt], det
	foreach v of any p25 p50 p75 {
		gen rich_`v'=(inc>=r(`v'))*(ln(inc)-ln(r(`v'))) if cty=="`c'"
		gen poor_`v'=(inc<r(`v'))*(ln(inc)-ln(r(`v'))) if cty=="`c'"
	}
	for ! in any 8 15 25 p25 p50 p75: ///
		reg sat_current_z rich_! poor_! if cty=="`c'" [aw=wt], robust ///
		\ replace brich_!=_b[rich_!] if cty=="`c'" ///
		\ replace serich_!=_se[rich_!] if cty=="`c'" ///
		\ replace bpoor_!=_b[poor_!] if cty=="`c'" ///
		\ replace sepoor_!=_se[poor_!] if cty=="`c'" ///
		\ lincom rich_!-poor_! ///
		\ replace diff_!=r(estimate) if cty=="`c'" ///
		\ replace sediff_!=r(se) if cty=="`c'" ///
		\ count if rich_!>0 & cty=="`c'" & sat_current_z~=. & wt>0 & ~missing(rich_!, sat_current_z) ///
		\ replace nrich_!=r(N) if cty=="`c'" ///
		\ count if poor_!<0 & cty=="`c'" & sat_current_z~=. & wt>0 & ~missing(poor_!, sat_current_z) ///
		\ replace npoor_!=r(N) if cty=="`c'"
	drop rich* poor*
}

for ! in any 8 15 25 p25 p50 p75: 	gen precision_!=sediff_!^(-2)
for ! in any 8 15 25 p25 p50 p75 \ @ in any "US$8,000" "US$15,000" "US$25,000" "25th percentile" "Median income" "75th percentile": la var brich_! "Cutoff=@"


count if t==1 & brich_15>bpoor_15 & nrich_15>=200 & npoor_15>=200
local above=r(N)
count if t==1 & brich_15<bpoor_15 & nrich_15>=200 & npoor_15>=200
local below=r(N)
bitesti `above'+`below' `below' .5, detail
count if t==1 & (brich_15<-.4 | brich_15>1 | bpoor_15<-.4 | bpoor_15>1) & (nrich_15>=200 & npoor_15>=200)
local offscale=r(N)

twoway ///
	(function y=x, range(-0.4 1) sort lpattern(dash) lwidth(thin) lcolor(black)) ///
	(scatter brich_15 bpoor_15 [w=precision_15] if t==1 & nrich_15>=200 & npoor_15>=200, msymbol(none) mlabel(cty) mlabpos(0) mlabcolor(navy)) ///
	if t==1 & nrich_15>=200 & npoor_15>=200 ///
	, ///
	xlabel(-.4(.2)1, angle(horizontal) format(%3.1f)) xtitle("") ///
	xtitle("{&beta}{subscript:poor}: Well-being-Income gradient for incomes <$15,000") ///
	ylabel(-.4(.2)1, angle(horizontal) format(%3.1f)) ytitle("")  ///
	ytitle("{&beta}{subscript:rich}: Well-being-Income gradient for incomes >$15,000") /// 
	yline(0, lcolor(black)) ///
	text(1 -.4 "Above: `above'", placement(3)) ///
	text(-.4 1 "Below: `below'", placement(9)) ///
	legend(off) ///
	name(fig3, replace) xsize(10) ysize(7.5)
graph export "$directory\Charts\fig3.eps", replace
graph save "$directory\Charts\fig3.gph", replace


foreach cutoff of any 8 15 25 p25 p50 p75 {
	local lb: variable label brich_`cutoff'
	count if t==1 & brich_`cutoff'>bpoor_`cutoff' & nrich_`cutoff'>=200 & npoor_`cutoff'>=200
	local above=r(N)
	count if t==1 & brich_`cutoff'<bpoor_`cutoff' & nrich_`cutoff'>=200 & npoor_`cutoff'>=200
	local below=r(N)
	bitesti `above'+`below' `below' .5, detail
	count if t==1 & (brich_`cutoff'<-.4 | brich_`cutoff'>1 | bpoor_`cutoff'<-.4 | bpoor_`cutoff'>1) & (nrich_`cutoff'>=200 & npoor_`cutoff'>=200)
	local offscale=r(N)
	if `offscale'==1 {
		local offscaletext "(1 country off-scale)"
	}
	if `offscale'>1 {
		local offscaletext "(`offscale' countries off-scale)"
	}
	twoway ///
		(function y=x, sort range(-0.4 1) lpattern(dash) lwidth(thin) lcolor(black)) ///
		(scatter brich_`cutoff' bpoor_`cutoff' [w=precision_`cutoff'] , msymbol(none) mlabel(cty) mlabpos(0) mlabcolor(navy)) ///
		if t==1 & brich_`cutoff'>-.4 & brich_`cutoff'<1 & bpoor_`cutoff'>-.4 & bpoor_`cutoff'<1 ///
			& nrich_`cutoff'>200 & npoor_`cutoff'>200, ///
		title("`lb'", ring(0) pos(12)) ///
		xlabel(-.4(.2)1, angle(horizontal) format(%3.1f)) xtitle("") ///
		ylabel(-.4(.2)1, angle(horizontal) format(%3.1f)) ytitle("") ///
		yline(0, lcolor(black)) ///
		text(.9 -.4 "Above: `above'", placement(3)) ///
		text(-.4 1 "Below: `below'", placement(9)) ///
		text(.9 .3 "`offscaletext'", size(small)) ///
		legend(off) ///
		name(richpoor_`cutoff', replace) xsize(10) ysize(7.5)
}

graph combine richpoor_8 richpoor_15 richpoor_25 richpoor_p25 richpoor_p50 richpoor_p75 ///
	, ///
	rows(3) colfirst ///
	b1title("{&beta}{subscript:poor}: Wellbeing-Income gradient: Income<cutoff") ///
	l1title("{&beta}{subscript:rich}: Well-being-Income gradient: Income>=cutoff") ///
	imargin(zero) xsize(7.5) ysize(10) name(richpoor_gwp, replace)
graph export "$directory\Charts\Appendix\fig3_6panel.eps", replace
graph save "$directory\Charts\Appendix\fig3_6panel.gph", replace




